import { SecretLintSourceCode, SecretLintSourceNodeLocation, SecretLintSourceNodePosition, SecretLintSourceNodeRange } from "@secretlint/types";
/**
 * This class represent of source code.
 */
export declare class SecretLintSourceCodeImpl implements SecretLintSourceCode {
    readonly hasBOM: boolean;
    readonly content: string;
    readonly filePath: string | undefined;
    readonly contentType: "binary" | "text" | "unknown";
    readonly ext: string;
    private structuredSource;
    constructor({ content, ext, filePath, contentType, }: {
        content: string;
        ext: string;
        filePath: string;
        contentType: "binary" | "text" | "unknown";
    });
    /**
     * get filePath
     * @returns {string|undefined}
     */
    getFilePath(): string | undefined;
    /**
     * @param {SecretLintSourceNodeLocation} loc - location indicator.
     * @return {[ number, number ]} range.
     */
    locationToRange(loc: SecretLintSourceNodeLocation): SecretLintSourceNodeRange;
    /**
     * @param {[ number, number ]} range - pair of indice.
     * @return {SecretLintSourceNodeLocation} location.
     */
    rangeToLocation(range: SecretLintSourceNodeRange): SecretLintSourceNodeLocation;
    /**
     * @param {Position} pos - position indicator.
     * @return {number} index.
     */
    positionToIndex(pos: SecretLintSourceNodePosition): number;
    /**
     * @param {number} index - index to the source code.
     * @return {Position} position.
     */
    indexToPosition(index: number): SecretLintSourceNodePosition;
}
//# sourceMappingURL=SecretLintSourceCodeImpl.d.ts.map